#include "utest.h"

#include "example.h"
#include "abs.h"
#include "idxmin.h"
#include "search.h"
#include "order3.h"
#include "sum.h"

/******************************************************************************/

// See the following page for the list of UTEST commands
// https://github.com/sheredom/utest.h

// Prefer "EXPECT" commands as they do not stop the execution of the tests

/******************************************************************************/

UTEST(example_function, positive_positive) {
  EXPECT_TRUE(example_function(1, 1));
}
UTEST(example_function, negative_positive) {
  EXPECT_FALSE(example_function(-1, 1));
}
UTEST(example_function, positive_negative) {
  EXPECT_FALSE(example_function(1, -1));
}

/******************************************************************************/

UTEST_STATE();

int main(int argc, const char *const argv[]) {
  if (utest_main(argc, argv) != 0){
    printf("\033[31m========== SOME TESTS FAILED ==========\033[0m\n");
  } else {
    printf("\033[32m==========  TESTS SUCCEEDED  ==========\033[0m\n");
  }
}
