#include <stddef.h>

/*@
  requires \valid_read(arr + (0 .. len-1));


  assigns \nothing ;

  behavior exists:
    assumes \exists integer j ; 0 <= j < len && arr[j] == value ;
    ensures 0 <= \result < len ;
    ensures arr[\result] == value ;

  behavior does_not_exists:
    assumes \forall integer j ; 0 <= j < len ==> arr[j] != value ;
    ensures \result == len ;

  complete behaviors ;
  disjoint behaviors ;
*/
size_t search(int* arr, size_t len, int value){
  /*@ loop invariant 0 <= i <= len;
      loop invariant \forall size_t j; 0 <= j < i ==> arr[j] != value;
      loop assigns i;
      loop variant len - i; */
  for(size_t i = 0; i < len; i++)
    if(arr[i] == value) return i;
  return len;
}
