#include <stddef.h>

/*@
    logic integer sum(int* array, integer b, integer e) =
      (b >= e) ? 0 : array[b] + sum(array, b+1, e);
*/

/*@ predicate incd_cell{L1,L2}(int* array, integer b, integer e, integer i) =
      \at(array[i], L1) + 1 == \at(array[i], L2) &&
      \forall integer j ; b <= j < e && j != i ==>
        \at(array[j], L1) == \at(array[j], L2);
*/
/*@ lemma incd_cell_means_incd_sum{L1, L2}:
      \forall int* array, integer b, e, i ;
        incd_cell{L1, L2}(array, b, e, i) ==>
	  sum{L2}(array, b, e) == sum{L1}(array, b, e) + 1 ;
*/

/*@ requires i < len ;
    ensures  sum(array, 0, len) == sum{Pre}(array, 0, len) + 1;
*/
void inc_cell(int* array, size_t len, size_t i){
  array[i]++ ;
  //@ assert incd_cell{Pre, Here}(array, 0, len, i);
}
